/**HEADER********************************************************************
 *
 * Copyright (c) 2010, 2013-2015 Freescale Semiconductor;
 * All Rights Reserved
 *
 *
 ***************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 **************************************************************************
 *
 * $FileName: audio_generator.c$
 * $Version :
 * $Date    :
 *
 * Comments:
 *
 * @brief  The file emulates a generator.
 *****************************************************************************/

/******************************************************************************
 * Includes
 *****************************************************************************/

#include "project.h"

#include "board.h"

#include "cp.h"

extern CP_STATUSCODE accelerometer_IncomingSingleTLVCallback (unsigned long p_Tag, unsigned long p_Len,unsigned char *p_MarshalledVal);


extern void sample_accelerometer_task (void *p_Dum);

#ifdef RUN_AS_CLIENT
#define SAMPLETASKPRIORITY (configMAX_PRIORITIES-3)
#endif

void main(void)
{
#ifdef RUN_AS_CLIENT    
    CP_COMMHANDLE a_ClientCommHandle;
#endif
#ifdef RUN_AS_SERVER
    CP_COMMHANDLE a_ServerCommHandle;
#endif

    hardware_init();

LED1_EN;    /*!< Enable target LED1 */
LED2_EN;    /*!< Enable target LED2 */
LED3_EN;    /*!< Enable target LED2 */

#ifdef RUN_AS_CLIENT    
    a_ClientCommHandle = cp_initCommLayerClient();

    /* create accelerometer sampling task */
    xTaskCreate(sample_accelerometer_task, "SampleTask", configMINIMAL_STACK_SIZE*3,
			(void *)a_ClientCommHandle, SAMPLETASKPRIORITY, (TaskHandle_t *) 0);
#endif    
#ifdef RUN_AS_SERVER
    a_ServerCommHandle = cp_initCommLayerServer();
    cp_RegisterIncomingSingleTLVPacketCallback(a_ServerCommHandle,accelerometer_IncomingSingleTLVCallback);
    
#endif    

    /* Start the scheduler */
    vTaskStartScheduler();
}

/* EOF */
